*! version 5.0
* 13 August 2018
* NIDS
* Master Income do file for Nids Wave 3

* THIS IS 7th INCOME DO FILE - INCOME RELEASE: 7 OF 7

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Income do file (1 of 7)"

version 12.0

*=====================================================================================================================================
***Final preparations for releasing
*=====================================================================================================================================

*Adding in the weights
use "$DataIN\hhderived_$VersionIN.dta", clear
keep w1_hhid w1_wgt
sort w1_hhid
save "$DataOUT\hhweightsmerge.dta", replace

*Taking all of the income variables that we want to keep
use "$DataOUT\hhdata.dta", clear
keep pid  w1_hhid hhsizer hhincome hhincome_flg hhq_inc hhq_incb hhq_incb_flg hhagric hhwage hhgovt hhother hhinvest hhcapital hhremitt hhimprent_inc hhimprent_flg pi_hhincome pi_hhagric pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhcapital pi_hhremitt fwag cwag swag cheq prof extr bonu othe help spen ppen uif comp dis chld fost care indi inhe rnt retr brid gift loan sale remt fwag_flg cwag_flg swag_flg cheq_flg prof_flg extr_flg bonu_flg othe_flg help_flg spen_flg ppen_flg uif_flg comp_flg dis_flg chld_flg fost_flg care_flg indi_flg inhe_flg rnt_flg retr_flg brid_flg gift_flg loan_flg sale_flg remt_flg
sort w1_hhid
merge m:1 w1_hhid using "$DataOUT\hhweightsmerge.dta"  //nokeep
drop _merge

*Some renaming 
foreach x of varlist hhincome hhincome_flg hhq_inc hhq_incb hhq_incb_flg hhagric hhwage hhgovt hhother hhinvest hhcapital hhremitt hhimprent_inc hhimprent_flg pi_hhincome pi_hhagric pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhcapital pi_hhremitt fwag cwag swag cheq prof extr bonu othe help spen ppen uif comp dis chld fost care indi inhe rnt retr brid gift loan sale remt fwag_flg cwag_flg swag_flg cheq_flg prof_flg extr_flg bonu_flg othe_flg help_flg spen_flg ppen_flg uif_flg comp_flg dis_flg chld_flg fost_flg care_flg indi_flg inhe_flg rnt_flg retr_flg brid_flg gift_flg loan_flg sale_flg remt_flg{
rename `x' w1_`x'
}
rename hhsizer w1_hhsizer
sort w1_hhid pid
save "$DataOUT\temp.dta", replace

*=====================================================================================================================================

***Household level release

*=====================================================================================================================================
*Dropping unneccessary variables
use "$DataOUT\temp.dta", clear
keep w1_hhid  w1_wgt w1_hhsizer w1_hhq_inc w1_hhq_incb w1_hhq_incb_flg w1_hhincome w1_hhincome_flg w1_hhwage w1_hhgovt w1_hhother w1_hhinvest w1_hhcapital w1_hhremitt w1_hhimprent_inc w1_hhimprent_flg w1_hhagric w1_pi_hhincome w1_pi_hhwage w1_pi_hhgovt w1_pi_hhother w1_pi_hhinvest w1_pi_hhcapital w1_pi_hhremitt w1_pi_hhagric
sort w1_hhid
drop if w1_hhid==w1_hhid[_n-1]

*Income quintiles and sextiles
gen w1_hhincome_pc=w1_hhincome/w1_hhsizer
gen quintweight=w1_hhsizer*w1_wgt
xtile w1_hhquint=w1_hhincome_pc [w=quintweight], nq(5)
label variable w1_hhquint "Per capita household income quintiles"
drop w1_hhincome_pc quintweight w1_wgt

sort w1_hhid
save "$DataOUT\release.dta", replace

*=====================================================================================================================================

***Individual level release

*=====================================================================================================================================

*Dropping uneccessary variables
use "$DataOUT\temp.dta", clear
keep pid w1_hhid  w1_fwag w1_cwag w1_swag w1_cheq w1_prof w1_extr w1_bonu w1_othe w1_help w1_spen w1_ppen w1_uif w1_comp w1_dis w1_chld w1_fost w1_care w1_indi w1_inhe w1_rnt w1_retr w1_brid w1_gift w1_loan w1_sale w1_remt w1_fwag_flg w1_cwag_flg w1_swag_flg w1_cheq_flg w1_prof_flg w1_extr_flg w1_bonu_flg w1_othe_flg w1_help_flg w1_spen_flg w1_ppen_flg w1_uif_flg w1_comp_flg w1_dis_flg w1_chld_flg w1_fost_flg w1_care_flg w1_indi_flg w1_inhe_flg w1_rnt_flg w1_retr_flg w1_brid_flg w1_gift_flg w1_loan_flg w1_sale_flg w1_remt_flg
order pid w1_hhid w1_fwag w1_cwag w1_swag w1_cheq w1_prof w1_extr w1_bonu w1_othe w1_help w1_spen w1_ppen w1_uif w1_comp w1_dis w1_chld w1_fost w1_care w1_indi w1_inhe w1_rnt w1_retr w1_brid w1_gift w1_loan w1_sale w1_remt w1_fwag_flg w1_cwag_flg w1_swag_flg w1_cheq_flg w1_prof_flg w1_extr_flg w1_bonu_flg w1_othe_flg w1_help_flg w1_spen_flg w1_ppen_flg w1_uif_flg w1_comp_flg w1_dis_flg w1_chld_flg w1_fost_flg w1_care_flg w1_indi_flg w1_inhe_flg w1_rnt_flg w1_retr_flg w1_brid_flg w1_gift_flg w1_loan_flg w1_sale_flg w1_remt_flg
sort pid

save "$DataOUT\release_indiv.dta", replace
erase "$DataOUT\hhweightsmerge.dta"
erase "$DataOUT\temp.dta"

*=====================================================================================================================================

***The final release files

*=====================================================================================================================================

*Household derived
use "$DataIN\hhderived_$VersionIN.dta", clear

*This logical fork makes sure that if this is run after the expenditure do-files, the vars created in this step will not be dropped
lookfor w1_h_expf
gen x=r(varlist)
cap tostring x, replace
if x=="."{
keep w1_hhid w1_prov2001 w1_prov2011 w1_geo2001 w1_geo2011 w1_cluster w1_dc2001  w1_dc2011 w1_mdbdc2011  w1_*wgt*
*w1_gps_s w1_gps_e
}
else{
keep w1_hhid w1_prov2001 w1_prov2011 w1_geo2001 w1_geo2011 w1_cluster w1_dc2001 w1_dc2011 w1_mdbdc2011 w1_*wgt* w1_h_expf w1_h_expnf w1_h_expenditure w1_h_exprough w1_h_rentexpend w1_h_rentexpend_flg w1_hhimprent_exp
*w1_gps_s w1_gps_e
}
save "$DataOUT\temp.dta", replace

*Puts together and saves the household derived release
clear
use "$DataOUT\temp.dta", clear
sort w1_hhid
merge 1:m w1_hhid using "$DataOUT\release.dta"  // nokeep
drop if _m ==2
drop _merge
compress
order w1_hhid w1_prov2001 w1_prov2011 w1_geo2001 w1_geo2011 w1_dc2001 w1_dc2011 w1_mdbdc2011 w1_cluster  w1_wgt w1_dwgt w1_dtwgt w1_hhsizer w1_hhquint w1_hhq_inc w1_hhq_incb w1_hhq_incb_flg w1_hhincome w1_hhincome_flg w1_hhwage w1_hhgovt w1_hhother w1_hhinvest w1_hhcapital w1_hhremitt w1_hhimprent_inc w1_hhimprent_flg w1_hhagric w1_pi_hhincome w1_pi_hhwage w1_pi_hhgovt w1_pi_hhother w1_pi_hhinvest w1_pi_hhcapital w1_pi_hhremitt w1_pi_hhagric
*w1_gps_s w1_gps_e
save "$DataOUT\hhderived_$VersionOUT", replace



*=====================================================================================================================================



erase "$DataOUT\temp.dta"

*Individual derived
use "$DataIN\indderived_$VersionIN.dta", clear

*This logical fork makes sure that if this is run after the expenditure and labour market do-files, the vars created in this step will not be dropped
lookfor w1_empl_stat
gen x=r(varlist)
cap tostring x, replace
if x=="."{
keep pid w1_hhid w1_quest_typ  w1_best_race  w1_best_gen  w1_best_dob* w1_best_age* w1_age_intervals  w1_best_mthpid w1_best_fthpid w1_best_edu w1_quest_typ w1_numzscore  w1_zhfa w1_zwfa w1_zbmi w1_zwfh 
}
else{
keep pid w1_hhid w1_quest_typ  w1_best_race  w1_best_gen w1_best_dob* w1_best_age* w1_age_intervals  w1_best_mthpid w1_best_fthpid  w1_best_edu w1_quest_typ w1_numzscore w1_empl_stat w1_empl_stat_inclprox  w1_zhfa w1_zwfa w1_zbmi w1_zwfh 
}
save "$DataOUT\temp.dta", replace

*Puts together and saves the individual derived release
clear
use "$DataOUT\temp.dta", clear /*This saving and reopening gets rid of unattached value labels*/
sort pid
merge 1:m pid using "$DataOUT\release_indiv.dta" // nokeep
order pid w1_hhid 
drop _merge
compress
order w1_hhid pid w1_quest_typ w1_best_race  w1_best_gen w1_best_dob* w1_best_age* w1_age_intervals w1_best_edu w1_best_mthpid  w1_best_fthpid  w1_numzscore w1_zhfa w1_zwfa w1_zbmi w1_zwfh 

label define w1_nonres -3 "Missing" -8 "Refused" -9 "Don't know", modify

label	values	w1_fwag	w1_nonres
label	values	w1_cwag	w1_nonres
label	values	w1_swag	w1_nonres
label	values	w1_cheq	w1_nonres
label	values	w1_prof	w1_nonres
label	values	w1_extr	w1_nonres
label	values	w1_bonu	w1_nonres
label	values	w1_othe	w1_nonres
label	values	w1_help	w1_nonres
label	values	w1_spen	w1_nonres
label	values	w1_ppen	w1_nonres
label	values	w1_uif	w1_nonres
label	values	w1_comp	w1_nonres
label	values	w1_dis	w1_nonres
label	values	w1_chld	w1_nonres
label	values	w1_fost	w1_nonres
label	values	w1_care	w1_nonres
label	values	w1_indi	w1_nonres
label	values	w1_inhe	w1_nonres
label	values	w1_rnt	w1_nonres
label	values	w1_retr	w1_nonres
label	values	w1_brid	w1_nonres
label	values	w1_gift	w1_nonres
label	values	w1_loan	w1_nonres
label	values	w1_sale	w1_nonres
label	values	w1_remt	w1_nonres

save "$DataOUT\indderived_$VersionOUT", replace

erase "$DataOUT\data.dta"
erase "$DataOUT\temp.dta"
erase "$DataOUT\prepdata.dta"
erase "$DataOUT\impdata.dta"
erase "$DataOUT\hhdata.dta"
erase "$DataOUT\release.dta"
erase "$DataOUT\release_indiv.dta"

*=====================================================================================================================================

clear

exit



 





